/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.beans.VAMC;
import gov.va.med.esr.ui.common.beans.VAMCSite;
import gov.va.med.esr.ui.common.beans.VISNVAMCSite;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VISN;

/**
 * UI lookup DAO for VISNVAMCSite facilities.
 *
 * @author Venky Kullampalle
 * @version 3.0
 */
public class VISNVAMCSiteDAO extends VAMCDAO
{
    /**
     * Gets the list VISNVAMCSite.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
 
    	List filteredVisnVamcSites = new ArrayList();
    	//Get all Facilities.
        List facilities = getLookupService().findAll(getBaseLookupClass());
        if(facilities==null)
        	return null;
        //Get All VAMCs
        List vamcs=getVAMCs(facilities);
        // VISN --> List of VAMCs
        Map vamcByVisn = getVISNVAMCMap(vamcs);    
        // Parent ID --> List of Facilities.
        Map siteByParent=getParentSiteMap(facilities);
        if(vamcByVisn != null) {
            for(Iterator iter = vamcByVisn.keySet().iterator(); iter.hasNext();) {
                VISN visn = (VISN)iter.next();
                List visnVamcs = (visn != null) ? (List)vamcByVisn.get(visn) : null;
                // If VAMCs exists under VISN, add VISN it to the List.
                if(visnVamcs != null) {
                	filteredVisnVamcSites.add(visn);
                	//Loop through VAMCs and add it to the List.
                    for(Iterator vamcIter=visnVamcs.iterator(); vamcIter.hasNext();) {
                        VAFacility vamc = (VAFacility)vamcIter.next();
                        //Add VAMC only if its parent is not VAMC.
                        if(vamc != null && !isInList(vamcs, vamc.getParentId())) {
                        	filteredVisnVamcSites.add(new VAMC(vamc));
                        	// Call this method to add its childrens.
                        	addFacilities(siteByParent,vamc,filteredVisnVamcSites,vamcs,false);
                        }
//                        List vamcSites=(List)siteByParent.get(vamc.getIdentifier());
//                        if(vamcSites!=null)
//                        {
//	                        for (Iterator facItr=vamcSites.iterator(); facItr.hasNext();)
//	                        {
//	                        	 VAFacility site = (VAFacility)facItr.next();
//	                             if(site != null) {
//	                             	filteredVisnVamcSites.add(new VAMCSite(site));
//	                             }
//	                        }
//                        }
                    } 
                }
            }
        }       
        return filteredVisnVamcSites;
    }  
   /**
    * 
    * @param siteByParent
    * @param site
    * @param filteredVamcSites
    * @param vamcs
    * @param isChild
    */
    private void addFacilities(Map siteByParent, VAFacility site, List filteredVamcSites,List vamcs, boolean isChild)
    {
    	if(siteByParent!=null && site!=null)
    	{
	    	List vamcSites=(List)siteByParent.get(site.getIdentifier());
	        if(vamcSites!=null){
	        /* 	If Facility is VAMC, add it to list and call addFacilities with flag true to add all its children.
           	  	All this logic is to display list in hierarchical list, like
           	  	VISN
           	 	.VAMC
           	  	. .VAMC
           	  	. . . Site
           	 */           	  
	            for (Iterator facItr=vamcSites.iterator(); facItr.hasNext();)
	            {
	            	 VAFacility fac = (VAFacility)facItr.next();
	                 if(fac != null && isInList(vamcs, fac.getIdentifier())) {	                	 
	                	 filteredVamcSites.add(new VAMCSite(fac));
	                	 addFacilities(siteByParent,fac,filteredVamcSites,vamcs,true);
	                 }else if(fac!=null)
	                 {
	                	 if(isChild)
	                		 filteredVamcSites.add(new VISNVAMCSite(fac));
	                	 else
	                		 filteredVamcSites.add(new VAMCSite(fac));
	                 }
	            }
	        }
    	}
    }
}
