/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.beans.VAMC;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VISN;

/**
 * UI lookup DAO for VISN facilities.
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class VISNVAMCDAO extends VAMCDAO
{
    /**
     * Gets the list VISNs and facilities.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
 
        List filteredVisnVamcs = new ArrayList();
        List facilities = getLookupService().findAll(getBaseLookupClass());
        try{
        List vamcs=getVAMCs(facilities);
        Map vamcByVisn = getVISNVAMCMap(vamcs);        
        if(vamcByVisn != null) {
            for(Iterator iter = vamcByVisn.keySet().iterator(); iter.hasNext();) {
                VISN visn = (VISN)iter.next();
                List visnVamcs = (visn != null) ? (List)vamcByVisn.get(visn) : null;
                if(visnVamcs != null) {
                	filteredVisnVamcs.add(visn);
                    for(Iterator vamcIter=visnVamcs.iterator(); vamcIter.hasNext();) {
                        VAFacility vamc = (VAFacility)vamcIter.next();
                        if(vamc != null) {
                        	filteredVisnVamcs.add(new VAMC(vamc));
                        }                        
                    } 
                }
            }
        }
        }catch(Throwable th){
        	th.printStackTrace();
        }
        return filteredVisnVamcs;
    }   
   
}
