/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.beans.VAMC;
import gov.va.med.esr.ui.common.beans.VISNSite;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VISN;

/**
 * UI lookup DAO for VISN facilities.
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class VISNParentFacilityDAO extends VAMCDAO
{
    /**
     * Gets the list VISNs and facilities.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
  
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
    
    	 List filteredLocations = new ArrayList();

         
          try{
          Map facilityByVisn = this.getLookupService().getParentVISNSiteMap();
         if(facilityByVisn != null) {
             for(Iterator iter = facilityByVisn.keySet().iterator(); iter.hasNext();) {
                 VISN visn = (VISN)iter.next();
                 List visnSites = (visn != null) ? (List)facilityByVisn.get(visn) : null;
                 if(visnSites != null) {
                     filteredLocations.add(visn);
                     for(Iterator facIter=visnSites.iterator(); facIter.hasNext();) {
                         VAFacility facility = (VAFacility)facIter.next();
                         if(facility != null) {
                             filteredLocations.add(new VISNSite(facility));
                         }
                     } 
                 }
             }
         }
         }catch(Throwable th){
        	th.printStackTrace();
        }
        
         return filteredLocations;
     }
}
