/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.beans.VAMC;
import gov.va.med.esr.ui.common.beans.VAMCSite;
import gov.va.med.esr.common.model.lookup.VAFacility;


/**
 * UI lookup DAO for VAMCSite facilities.
 *
 * @author Venky Kullampalle
 * @version 3.0
 */
public class VAMCSiteDAO extends VAMCDAO
{
    /**
     * Gets the list VAMCs and facilities.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException { 
        
	    List filteredVamcSites = new ArrayList();
	    //Get All fecilities.
	    List facilities = getLookupService().findAll(getBaseLookupClass());
	    if(facilities==null)
        	return null;
	    //Get all VAMCs
	    List vamcs=getVAMCs(facilities); 
	    //Get parent ID --> List of Facility
	    Map siteByParent=getParentSiteMap(facilities);        
	    if(vamcs != null) { 
	    	//Loop through VAMCs and add to List.
	        for(Iterator vamcIter=vamcs.iterator(); vamcIter.hasNext();) {
	            VAFacility vamc = (VAFacility)vamcIter.next();
	            //If VAMC parent is not of a type VAMC, then add to List
	            if(vamc != null && !isInList(vamcs, vamc.getParentId())) {
	            	filteredVamcSites.add(vamc);
	            	// Call this method to add children of this VAMC to List.
	            	addFacilities(siteByParent,vamc,filteredVamcSites,vamcs, false);
	            }
//	            else
//	            {
//	            	continue;
//	            }
//	            List vamcSites=(List)siteByParent.get(vamc.getIdentifier());
//	            if(vamcSites!=null){
//		            for (Iterator facItr=vamcSites.iterator(); facItr.hasNext();)
//		            {
//		            	 VAFacility site = (VAFacility)facItr.next();
//		                 if(site != null) {
//		                	 filteredVamcSites.add(new VAMC(site));
//		                 }
//		            }
//	            }
	        } 
	    }           
	    return filteredVamcSites;
    } 
    
    /**
     * 
     * @param siteByParent
     * @param site
     * @param filteredVamcSites
     * @param vamcs
     * @param isChild
     */
    private void addFacilities(Map siteByParent, VAFacility site, List filteredVamcSites,List vamcs, boolean isChild)
    {
    	if(siteByParent!=null && site!=null)
    	{
    		//Get all children of passed VAMC.
	    	List vamcSites=(List)siteByParent.get(site.getIdentifier());
	        if(vamcSites!=null){
	        	//Loop through and add it to collection.
	            for (Iterator facItr=vamcSites.iterator(); facItr.hasNext();)
	            {
	            	 VAFacility fac = (VAFacility)facItr.next();
	            	 /* 	If Facility is VAMC, add it to list and call addFacilities with flag true to add all its children.
	            	  	All this logic is to display list in hierarchical list, like
	            	 	VAMC
	            	  	.VAMC
	            	  	. . Site
	            	 */
	                 if(fac != null && isInList(vamcs, fac.getIdentifier())) {	                	 
	                	 filteredVamcSites.add(new VAMC(fac));
	                	 addFacilities(siteByParent,fac,filteredVamcSites,vamcs,true);
	                 }else if(fac!=null)
	                 {
	                	 if(isChild)
	                		 filteredVamcSites.add(new VAMCSite(fac));
	                	 else
	                		 filteredVamcSites.add(new VAMC(fac));
	                 }
	            }
	        }
    	}
    }
}
