/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VAFacilityType;
import gov.va.med.esr.common.model.lookup.VISN;

/**
 * UI lookup DAO for VAMC facilities.
 *
 * @author Venky Kullampalle
 * @version 3.0
 */
public class VAMCDAO extends VAFacilityAbstractLookupDAO
{
    /**
     * Gets the list  VAMC facilities.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
 
        List filteredVamc = new ArrayList();
        List facilities = getLookupService().findAll(getBaseLookupClass());
        if(facilities==null)
        	return null;
        List vamcs=getVAMCs(facilities);
        for (Iterator facItr=vamcs.iterator(); facItr.hasNext();)
        {
        	 VAFacility site = (VAFacility)facItr.next();
             if(site != null) {
            	 filteredVamc.add(site);
          }         
        }
        return filteredVamc;
    }    
    
    /**
     * This method returns all VAMCs form the passed facilities list.
     * @param facilities
     * @return the list of sites
     */
    public List getVAMCs(List facilities)
    {
    	List vamcs=new ArrayList();
    	//Loop through facilities, add it to return List only if it is of type VAMC.
    	if(facilities!=null)
    	{
	    	for(Iterator it=facilities.iterator(); it.hasNext();)
	    	{
	    		VAFacility facility = (VAFacility)it.next();
	    		if(facility.getType().getCode().equals(VAFacilityType.CODE_VAMC.getCode()))
	    		{
	    			vamcs.add(facility);
	    		}
	    	} 
    	}
    	return vamcs;
    	
    }
    
    /**
     * This method verifies passed ID is in List or not.
     * @param vamcs list of VAMCS
     * @param Id
     * @return True if it is in the list or false if not.
     */
    protected boolean isInList(List vamcs,BigDecimal Id )
    {
    	if(vamcs!=null && Id!=null)
    	{
    		VAFacility site=null;
    		for(Iterator it=vamcs.iterator(); it.hasNext();)
    		{
    			site=(VAFacility)it.next();
    			if(site.getIdentifier().equals(Id))
    				return true;
    		}
    	}
    	return false;
    }
    
    /**
     * This method returns parent_id --> list of VAFacilities
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public Map getParentSiteMap(List facilities) throws UnknownLookupTypeException, ClassNotFoundException {
      
    	//Parent ID --> List of VAFacility
        Map facilityByParent = new LinkedHashMap();
        if (facilities != null) {
            for (Iterator iter = facilities.iterator(); iter.hasNext();) {
                VAFacility facility = (VAFacility)iter.next();
                BigDecimal parentId = facility.getParentId();
                List vamcFacility = (parentId != null) ? (List)facilityByParent.get(parentId) : null;
                if(vamcFacility == null) {
                	vamcFacility = new ArrayList();
                	facilityByParent.put(parentId,vamcFacility);
                }                
                	vamcFacility.add(facility);                
            }
        }
        return facilityByParent;        
    }
    

    
    /**
     * This method returns map of VISN and list of VAMCs for this VISN
     * @param vamcs
     * @return
     * @throws UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public Map getVISNVAMCMap(Collection vamcs) throws UnknownLookupTypeException, ClassNotFoundException {        
    	
    	// VISN ID --> List of VAMCs.
         Map vamcByVisn = new LinkedHashMap();
         //VISN --> List of VAMCs
         Map facilitySiteMap = new LinkedHashMap();        
         if (vamcs != null) {
        	 // build VISN ID --> List of VAMCs.
             for (Iterator iter = vamcs.iterator(); iter.hasNext();) {
                 VAFacility facility = (VAFacility)iter.next();
                 BigDecimal visnId = facility.getVisnId();
                 List visnVamc = (visnId != null) ? (List)vamcByVisn.get(visnId) : null;
                 if(visnVamc == null) {
                 	visnVamc = new ArrayList();
                 	vamcByVisn.put(visnId,visnVamc);
                 }
                 if(visnVamc != null) {
                 	visnVamc.add(facility);
                 }
             }
         }
         List visns = getLookupService().findAll(VISN.class);
         //   build VISN --> List of VAMCs.
         for(Iterator iter = visns.iterator(); iter.hasNext();) {
             VISN visn = (VISN)iter.next();
             List visnFacilities = (List)vamcByVisn.get(visn.getIdentifier());
             facilitySiteMap.put(visn,visnFacilities);
         }    	    	
         return facilitySiteMap;
    }    
}
