/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * UI lookup DAO for VISN facilities.
 *
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class VAFacilityExceptVBADAO extends VAFacilityAbstractLookupDAO
{
    /**
     * Gets the list VISNs and facilities.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
 
        List filteredLocations = new ArrayList();
        try {
            filteredLocations.addAll(getLookupService().findAll(getBaseLookupClass()));
            VAFacility vba = (VAFacility)getLookupService().getByCode(getBaseLookupClass(), VAFacility.CODE_MVR.getCode());
            if(vba != null) {
                filteredLocations.remove(vba);
            }
        } catch(UnknownLookupCodeException ex) {
            throw new RuntimeException(ex);
        }
        return filteredLocations;
    }
}
