// Package 
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;

/**
 * UI lookup DAO for VA facilities sorted by code (i.e. station number).
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class VAFacilityDAO extends VAFacilityAbstractLookupDAO
{
    /**
     * Sorts the list of VAFacility objects by code.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List locations = getLookupService().findAll(getBaseLookupClass());
        if (locations != null)
        {
            sortFacilitiesByCode(locations);
        }
        return locations;
    }
}
