// Package 
package gov.va.med.esr.ui.common.dao;

// ESR Classes
import gov.va.med.esr.common.model.lookup.VAFacility;

import java.util.Comparator;
import java.util.Collections;
import java.util.List;

/**
 * Abstract base class for VAFacility based UI lookup DAOs'.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public abstract class VAFacilityAbstractLookupDAO extends UIAbstractLookupDAO
{
    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return VAFacility.class;
    }

    /**
     * Sorts the facility list by code.
     * @param facilities the list of VAFacility objects.
     */
    public void sortFacilitiesByCode(List facilities)
    {
        if (facilities != null)
        {
            // Sort the facilities by code
            Comparator comparator = new Comparator()
            {
                public int compare(Object object1, Object object2)
                {
                    String name1 = (object1 != null && object1 instanceof VAFacility) ?
                        ((VAFacility)object1).getCode() : null;
                    String name2 = (object2 != null && object2 instanceof VAFacility) ?
                        ((VAFacility)object2).getCode() : null;
                    return (name1 != null && name2 != null) ? name1.compareTo(name2) : 0;
                }
            };
            Collections.sort(facilities, comparator);
        }
    }
}
