/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

import java.util.List;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.service.UserAdminService;

public class UserLookupDAO extends UIAbstractLookupDAO {

    private UserAdminService userAdminService = null;
    
    public List findAll() throws UnknownLookupTypeException,
            ClassNotFoundException {
        try {
            return getUserAdminService().findAllUsers();
        }catch(Exception e) {
            throw new RuntimeException(e.getMessage(),e);
        }
    }
    
    public Lookup getByCode(String className, String code)
    throws UnknownLookupTypeException, ClassNotFoundException {

        try {
            return getUserAdminService().getByCode(code);
        }catch (Exception e) {
            throw new RuntimeException("Fialed to Retrieve User Information for username " + code,e);
        }
    }
    
    public UserAdminService getUserAdminService() {
        return userAdminService;
    }
    
    public void setUserAdminService(UserAdminService userAdminService) {
        this.userAdminService = userAdminService;
    }
    
}
