// Package 
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.lookup.Country;

/**
 * UI lookup DAO for states that belong to the United States.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class USStateDAO extends UIAbstractLookupDAO
{
    /**
     * Filters the standard state list for ones that reside in the United States.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredStates = new ArrayList();
        List allStates = getLookupService().findAll(getBaseLookupClass());
        if (allStates != null)
        {
            for (Iterator iter = allStates.iterator(); iter.hasNext();)
            {
                State state = (State)iter.next();
                Country country = state.getCountry();
                if ((country != null) && (Country.CODE_USA.getName().equals(country.getCode())))
                {
                    filteredStates.add(state);
                }
            }
        }
        return filteredStates;
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return State.class;
    }
}
