package gov.va.med.esr.ui.common.dao;

import gov.va.med.esr.common.model.lookup.MHDocumentType;
import gov.va.med.esr.common.model.lookup.PHDocumentType;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.model.lookup.Lookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UIMHDocumentTypeDAO extends UIAbstractLookupDAO
{
	   /**
     * Filters the standard associations for 5 types: Emergency contact, other emergency contact
     * primary next of kin, other next of kin, and designee.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredMHDocumentTypes = new ArrayList();
        List allMHDocumentTypes = getLookupService().findAll(getBaseLookupClass());
        if (allMHDocumentTypes != null)
        {
            Lookup lookup = null;
            String code = null;
            for (Iterator iter = allMHDocumentTypes.iterator(); iter.hasNext();)
            {
                lookup = (Lookup)iter.next();
                code = lookup.getCode();
                if (PHDocumentType.CODE_VBA_DOD_FILE.getName().equals(code) ||
                		PHDocumentType.CODE_OTHER_OFFICIAL_SVC_RECORDS.getName().equals(code))
                {
                	filteredMHDocumentTypes.add(lookup);
                }    
            }
        }
        return filteredMHDocumentTypes;
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return PHDocumentType.class;
    }
}
