package gov.va.med.esr.ui.common.dao;

import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.model.lookup.Lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class UIMHDataSourceDAO extends UIAbstractLookupDAO
{
	   /**
     * Filters the standard associations for 5 types: Emergency contact, other emergency contact
     * primary next of kin, other next of kin, and designee.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
    	
    	List filteredMHDataSource = getLookupService().findAll(getBaseLookupClass());
        if (filteredMHDataSource != null)
        {
        	sortMHDataSourceByCode(filteredMHDataSource);
        }
        return filteredMHDataSource;
    }
    
    public void sortMHDataSourceByCode(List mhdatasource)
    {
        if (mhdatasource != null)
        {
            // Sort the facilities by code
            Comparator comparator = new Comparator()
            {
                public int compare(Object object1, Object object2)
                {
                    String name1 = (object1 != null && object1 instanceof MHDataSource) ?
                        ((MHDataSource)object1).getCode() : null;
                    String name2 = (object2 != null && object2 instanceof MHDataSource) ?
                        ((MHDataSource)object2).getCode() : null;
                    return (name1 != null && name2 != null) ? name1.compareTo(name2) : 0;
                }
            };   

           // Collections.sort(mhdatasource, comparator); 
            
            Collections.sort(mhdatasource, Collections.reverseOrder(comparator));
        }
    }
    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return MHDataSource.class;
    }
}
