/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

// Framework Classes
import gov.va.med.fw.model.lookup.Lookup;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.AssociationType.Code;

/**
 * UI lookup DAO for preferred facilities.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class UIAssociationTypeDAO extends UIAbstractLookupDAO
{
    /**
     * Filters the standard associations for 3 types: Power of Attorney, Guardian Civil, and Guardian VA.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredAssociationTypes = new ArrayList();
        List allAssociationTypes = getLookupService().findAll(getBaseLookupClass());
        if (allAssociationTypes != null)
        {
            Lookup lookup = null;
            String code = null;
            for (Iterator iter = allAssociationTypes.iterator(); iter.hasNext();)
            {
                lookup = (Lookup)iter.next();
                code = lookup.getCode();
                if (AssociationType.CODE_POWER_OF_ATTORNEY.getName().equals(code) ||
                    AssociationType.CODE_GUARDIAN_CIVIL.getName().equals(code) ||
                    AssociationType.CODE_GUARDIAN_VA.getName().equals(code))
                {
                    filteredAssociationTypes.add(lookup);
                }    
            }
        }
        return filteredAssociationTypes;
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return AssociationType.class;
    }
}
