package gov.va.med.esr.ui.common.dao;

import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.model.lookup.Lookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UIAssociationTypeAddPersonDAO extends UIAbstractLookupDAO
{
	   /**
     * Filters the standard associations for 5 types: Emergency contact, other emergency contact
     * primary next of kin, other next of kin, and designee.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredAssociationTypes = new ArrayList();
        List allAssociationTypes = getLookupService().findAll(getBaseLookupClass());
        if (allAssociationTypes != null)
        {
            Lookup lookup = null;
            String code = null;
            for (Iterator iter = allAssociationTypes.iterator(); iter.hasNext();)
            {
                lookup = (Lookup)iter.next();
                code = lookup.getCode();
                if (AssociationType.CODE_EMERGENCY_CONTACT.getName().equals(code) ||
                	AssociationType.CODE_OTHER_EMERGENCY_CONTACT.getName().equals(code) ||
                	AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getName().equals(code) ||
                	AssociationType.CODE_OTHER_NEXT_OF_KIN.getName().equals(code) ||
                	AssociationType.CODE_DESIGNEE.getName().equals(code) ) 
                {
                    filteredAssociationTypes.add(lookup);
                }    
            }
        }
        return filteredAssociationTypes;
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return AssociationType.class;
    }
}
