/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.model.lookup.Indicator;

/**
 * UI lookup DAO for indicator.
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class SortedIndicatorDAO extends UIAbstractLookupDAO
{
    /**
     * Gets Indicators in the order of Yes, No and Unknown.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List sortedList = new ArrayList();
        try {
            sortedList.add(this.getLookupService().getByCode(getBaseLookupClass(), Indicator.YES.getCode()));
            sortedList.add(this.getLookupService().getByCode(getBaseLookupClass(), Indicator.NO.getCode()));
            sortedList.add(this.getLookupService().getByCode(getBaseLookupClass(), Indicator.UNKNOWN.getCode()));
        } catch(UnknownLookupCodeException ex) {
            throw new UnknownLookupTypeException(ex.getMessage(), getBaseLookupClass());
        }
        return sortedList;
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return Indicator.class;
    }
}
