/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.model.lookup.SystemParameterUnit;

/**
 * UI lookup DAO for SSA Verification Frequency Units.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class SSAVerificationFrequencyUnitDAO extends UIAbstractLookupDAO
{
    /**
     * Filters the system parameter units.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        Set allowedUnits = new HashSet();
        allowedUnits.add(SystemParameterUnit.CODE_WEEKS.getName());
        allowedUnits.add(SystemParameterUnit.CODE_MONTHS.getName());

        List filteredUnits = new ArrayList();
        List allUnits = getLookupService().findAll(getBaseLookupClass());
        if (allUnits != null && allUnits.size() > 0)
        {
            SystemParameterUnit unit = null;
            for (Iterator iter = allUnits.iterator(); iter.hasNext();)
            {
                unit = (SystemParameterUnit)iter.next();
                if (allowedUnits.contains(unit.getCode()))
                {
                    filteredUnits.add(unit);
                }
            }
        }
        return filteredUnits;
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return SystemParameterUnit.class;
    }
}
