// Package
package gov.va.med.esr.ui.common.dao;

// Java Classes
import gov.va.med.esr.service.ReportStatus;
import gov.va.med.esr.service.UnknownLookupTypeException;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * UI lookup DAO for Report Status.  
 *
 * @author Venky Kullampalle
 * @version 3.0
 */
public class ReportStatusDAO extends UIAbstractLookupDAO
{
   /**
    * Returns list of ReportStatus VOs
    */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List reportStatuses = new ArrayList(); 
        
        //Populate Active ReportStatus
        ReportStatus active=new ReportStatus();
        setPrivateFieldData(active,"gov.va.med.fw.model.lookup.AbstractLookup","setCode",ReportStatus.ACTIVE.getCode());
        setPrivateFieldData(active,"gov.va.med.fw.model.lookup.AbstractLookup","setDescription",ReportStatus.ACTIVE_DESCRIPTION);
        reportStatuses.add(active);
        
        //Populate Inactive ReportStatus
        ReportStatus archived=new ReportStatus();
        setPrivateFieldData(archived,"gov.va.med.fw.model.lookup.AbstractLookup","setCode",ReportStatus.INACTIVE.getCode());
        setPrivateFieldData(archived,"gov.va.med.fw.model.lookup.AbstractLookup","setDescription",ReportStatus.INACTIVE_DESCRIPTION);
        reportStatuses.add(archived);
        return reportStatuses;
    }
    
    /**
     * set private field data of an object by modufying the method accessibility 
     * in the loaded class object
     * @param obj
     * @param className
     * @param methodName
     * @param data
     */
    private static void setPrivateFieldData(Object obj, String className, String methodName, Object data)
    throws ClassNotFoundException
    {
            try{    
                Class objectClass = Class.forName(className);
                final Method[] methods = objectClass.getDeclaredMethods();
                
                for (int i=0; i<methods.length; i++)
                {           
                    
                    if (methods[i].getName().equals(methodName))
                    {
                        final Object params[] = new Object[1];
                        params[0] = data;
                        methods[i].setAccessible(true);
                        methods[i].invoke(obj,params);
                        break;
                    }
                }
            }
            catch(Exception e)
            {
                throw new RuntimeException(e);
            }
        }   
}
