/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

// ESR Classes

import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;


/**
 * UI lookup DAO for VISN facilities.
 *
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class ReportFacilityDisplayByExceptVAMCDAO extends UIAbstractLookupDAO
{
    /**
     * Gets the list VISNs and facilities.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
 
        List filteredDisplayBy = new ArrayList();
        try {
        	filteredDisplayBy.addAll(getLookupService().findAll(ReportFacilityDisplayBy.class));
        	removeReportFacilityDisplayBy(filteredDisplayBy,ReportFacilityDisplayBy.CODE_VAMC.getCode());
        	removeReportFacilityDisplayBy(filteredDisplayBy,ReportFacilityDisplayBy.CODE_VISN_VAMC_SITE.getCode());
        	removeReportFacilityDisplayBy(filteredDisplayBy,ReportFacilityDisplayBy.CODE_VAMC_SITE.getCode());
        	removeReportFacilityDisplayBy(filteredDisplayBy,ReportFacilityDisplayBy.CODE_VISN_VAMC.getCode());        	
        } catch(Exception ex) {
            throw new RuntimeException(ex);
        }
        return filteredDisplayBy;
    }
    /**
     * 
     * @param facilityDisplays
     * @param facilityDisplayByCode
     */
    private void removeReportFacilityDisplayBy(List facilityDisplays,String facilityDisplayByCode )
    {
    	if(facilityDisplays!=null && facilityDisplayByCode!=null)
    	{
    		for(Iterator it=facilityDisplays.iterator();it.hasNext();)
    		{
    			ReportFacilityDisplayBy facilitytDisplay=(ReportFacilityDisplayBy)it.next();
    			if(facilitytDisplay.getCode().equals(facilityDisplayByCode))
    			{
    				it.remove();
    				return;
    			}
    		}
    	}
    }   	
}
