/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;

// ESR Classes
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.service.UnknownLookupTypeException;

public class RelationshipDAO extends UIAbstractLookupDAO
{
    private static Set validRelationships = null;

    static
    {
        validRelationships = new HashSet();
        validRelationships.add(Relationship.CODE_SON.getName());
        validRelationships.add(Relationship.CODE_STEPSON.getName());
        validRelationships.add(Relationship.CODE_DAUGHTER.getName());
        validRelationships.add(Relationship.CODE_STEPDAUGHTER.getName());
    }

    /**
     * Filters the standard list of Relationship's.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredRelationships = new ArrayList();
        List allRelationships = getLookupService().findAll(getBaseLookupClass());
        if (allRelationships != null)
        {
            Relationship relationship = null;
            for (Iterator iter = allRelationships.iterator(); iter.hasNext();)
            {
                relationship = (Relationship)iter.next();
                if (validRelationships.contains(relationship.getCode()))
                {
                    filteredRelationships.add(relationship);
                }
            }
        }
        return filteredRelationships;
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return Relationship.class;
    }
}
