package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VAFacilityType;

/**
 * UI lookup DAO for preferred facilities.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class PreferredFacilityDAO extends VAFacilityAbstractLookupDAO
{
    private static Set preferredFacilityTypes = null;

    static
    {
        preferredFacilityTypes = new HashSet();
        preferredFacilityTypes.add(VAFacilityType.CODE_CBOC.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_HCS.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_MROC.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_MCMD.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_MCM.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_MORC.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_OC.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_OCS.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_OPC.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_ORC.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_SOC.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_VAMC.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_HEALTHCARE.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_MROC_MRO.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_MOC.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_NETWORK.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_OCMC.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_SATELLITE.getName());
        preferredFacilityTypes.add(VAFacilityType.CODE_VA_ROSEBURG.getName());
    }

    /**
     * Filters the standard list of VA Facilities based on a list of facility types.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredLocations = new ArrayList();
        List allLocations = getLookupService().findAll(getBaseLookupClass());
        if (allLocations != null)
        {
            VAFacility facility = null;
            for (Iterator iter = allLocations.iterator(); iter.hasNext();)
            {
                facility = (VAFacility)iter.next();
                VAFacilityType facilityType = facility.getType();
                if (preferredFacilityTypes.contains(facilityType.getCode()))
                {
                    filteredLocations.add(facility);
                }
            }
        }

        // Sort the facilities
        sortFacilitiesByCode(filteredLocations);

        return filteredLocations;
    }
}
