/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

// ESR Classes
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.service.UnknownLookupTypeException;

public class PendingEnrollmentStatusDAO extends UIAbstractLookupDAO
{
    private static Set pendingEnrollmentStatuses = null;
    
    static
    {
        pendingEnrollmentStatuses = EnrollmentStatus.getPendingEnrollmentStatuses();
    }

    /**
     * Filters the standard list of pending enrollmentStatus's.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredEnrollmentStatuses = new ArrayList();
        List allEnrollmentStatuses = getLookupService().findAll(getBaseLookupClass());
        if (allEnrollmentStatuses != null)
        {
            EnrollmentStatus enrollmentStatus = null;
            for (Iterator iter = allEnrollmentStatuses.iterator(); iter.hasNext();)
            {
                enrollmentStatus = (EnrollmentStatus)iter.next();
                if (pendingEnrollmentStatuses.contains(enrollmentStatus.getCode()))
                {
                    filteredEnrollmentStatuses.add(enrollmentStatus);
                }
            }
        }
        return filteredEnrollmentStatuses;
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return EnrollmentStatus.class;
    }
}
