// Package 
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

// ESR Classes
import gov.va.med.esr.common.model.lookup.POWDataSource;
import gov.va.med.esr.service.UnknownLookupTypeException;

/**
 * UI lookup DAO for Address Phone Types.  Pre-certification is filtered out of the list of phone types.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class POWDataSourceDAO extends UIAbstractLookupDAO
{
    private static Set invalidDataSources = null;

    static
    {
        invalidDataSources = new HashSet();
        invalidDataSources.add(POWDataSource.CODE_MVR_VBA.getCode());
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return POWDataSource.class;
    }

    /**
     * Filters the standard list of Phone Types to exclude pre-certification.
     *
     * @return The list of PhoneType objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredDataSources = new ArrayList();
        List allDataSources = getLookupService().findAll(getBaseLookupClass());
        if (allDataSources != null)
        {
            for (Iterator iter = allDataSources.iterator(); iter.hasNext();)
            {
                POWDataSource dataSource = (POWDataSource)iter.next();
                if (!invalidDataSources.contains(dataSource.getCode()))
                {
                    filteredDataSources.add(dataSource);
                }
            }
        }

        return filteredDataSources;
    }
}
