/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

// Framework Classes
import gov.va.med.fw.model.lookup.Lookup;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.model.lookup.ConflictLocation;

/**
 * UI lookup DAO for preferred facilities.
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class OEFOIFCombatLocationDAO extends UIAbstractLookupDAO
{
    /**
     * Filters the standard combat locations for 4 types: OEF, OIF, Unknown OEF/OIF and Unspecified OEF/OIF.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List oefoifCombatLocations = new ArrayList();
        List conflictLocations = getLookupService().findAll(getBaseLookupClass());
        if (conflictLocations != null) {
            Lookup lookup = null;
            String code = null;
            for (Iterator iter = conflictLocations.iterator(); iter.hasNext();)
            {
                lookup = (Lookup)iter.next();
                code = lookup.getCode();
                if (ConflictLocation.CODE_OEF.getCode().equals(code) ||
                    ConflictLocation.CODE_OIF.getCode().equals(code) ||
                    ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode().equals(code) ||
                    ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode().equals(code))
                {
                    oefoifCombatLocations.add(lookup);
                }
            }
        }
        return oefoifCombatLocations;
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return ConflictLocation.class;
    }
}
