/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;

// ESR Classes
import gov.va.med.esr.common.model.lookup.MaritalStatus;
import gov.va.med.esr.service.UnknownLookupTypeException;

public class MaritalStatusDAO extends UIAbstractLookupDAO
{
    private static Set validMaritalStatuses = null;

    static
    {
        validMaritalStatuses = new HashSet();
        validMaritalStatuses.add(MaritalStatus.CODE_DIVORCED.getName());
        validMaritalStatuses.add(MaritalStatus.CODE_MARRIED.getName());
        validMaritalStatuses.add(MaritalStatus.CODE_NEVERMARRIED.getName());
        validMaritalStatuses.add(MaritalStatus.CODE_SEPARATED.getName());
        validMaritalStatuses.add(MaritalStatus.CODE_UNKNOWN.getName());
        validMaritalStatuses.add(MaritalStatus.CODE_WIDOWED.getName());
    }

    /**
     * Filters the standard list of MaritalStatus's.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredMaritalStatuses = new ArrayList();
        List allMaritalStatuses = getLookupService().findAll(getBaseLookupClass());
        if (allMaritalStatuses != null)
        {
            MaritalStatus maritalStatus = null;
            for (Iterator iter = allMaritalStatuses.iterator(); iter.hasNext();)
            {
                maritalStatus = (MaritalStatus)iter.next();
                if (validMaritalStatuses.contains(maritalStatus.getCode()))
                {
                  filteredMaritalStatuses.add(maritalStatus);
                }
            }
        }
        return filteredMaritalStatuses;
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return MaritalStatus.class;
    }
}
