/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

// ESR Classes
import gov.va.med.esr.common.model.lookup.ComAACErrorType;
import gov.va.med.esr.common.model.lookup.ComAACRejectReasonType;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.beans.ComAACLetterRejectErrorType;
import gov.va.med.esr.ui.common.beans.EnrollmentPriorityGroupAndSubGroup;
import gov.va.med.esr.ui.report.action.ReportConstants;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;
import gov.va.med.fw.util.StringUtils;

/**
 * UI lookup DAO for Letter Reject and Error reasons.
 *
 * @author Sanjay Gupta
 * @version 1.0
 */
public class LetterRejectErrorReasonDAO extends UIAbstractLookupDAO
{	
    /**
     * Gets the list VISNs and facilities.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
 
        List rejectErrorReasons = new ArrayList();
        Collection rejectReasons = this.getLookupService().findAll(ComAACRejectReasonType.class);
        Collection errorTypes = this.getLookupService().findAll(ComAACErrorType.class);
        
        Iterator iter = rejectReasons.iterator();
        while (iter.hasNext()) {
        	AbstractNamedLookup lookup = (AbstractNamedLookup)iter.next();
        	ComAACLetterRejectErrorType uiLookup = new ComAACLetterRejectErrorType(ReportConstants.REJECT_CODE_PREFIX + lookup.getCode(), lookup.getDescription());
        	rejectErrorReasons.add(uiLookup);
        }

        iter = errorTypes.iterator();
        while (iter.hasNext()) {
        	AbstractNamedLookup lookup = (AbstractNamedLookup)iter.next();
        	ComAACLetterRejectErrorType uiLookup = new ComAACLetterRejectErrorType(ReportConstants.ERROR_CODE_PREFIX + lookup.getCode(), lookup.getDescription());
        	rejectErrorReasons.add(uiLookup);
        }
        
        return rejectErrorReasons;
    }
}
