// Package
package gov.va.med.esr.ui.common.dao;

import java.util.List;

import gov.va.med.esr.common.model.lookup.HandBookReleaseControl;
import gov.va.med.esr.service.UnknownLookupTypeException;

public class HandBookReleaseCtlDAO extends UIAbstractLookupDAO
{
    
    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return HandBookReleaseControl.class;
    }

    /**
     * Filters the standard list of BadAddressResons to exclude invalid options for GUI.
     *
     * @return The list of BadAddressReason.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
      
        return getLookupService().findAll(getBaseLookupClass());
    }
}
