/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

// ESR Classes
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.beans.EnrollmentPriorityGroupAndSubGroup;
import gov.va.med.fw.util.StringUtils;

/**
 * UI lookup DAO for VISN facilities.
 *
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class EnrollmentPriorityGroupAndSubGroupDAO extends UIAbstractLookupDAO
{
    /**
     * Gets the list VISNs and facilities.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
 
        List enPriGroups = new ArrayList();
        Collection priorityGroups = this.getLookupService().findAll(EnrollmentPriorityGroup.class);
        Collection prioritySubGroups = this.getLookupService().findAll(EnrollmentPrioritySubGroup.class);
        for(Iterator iter=priorityGroups.iterator(); iter.hasNext();) {
            EnrollmentPriorityGroup priorityGroup = (EnrollmentPriorityGroup)iter.next();
            enPriGroups.add(new EnrollmentPriorityGroupAndSubGroup(priorityGroup,null));
            if(StringUtils.equals(priorityGroup.getCode(),EnrollmentPriorityGroup.GROUP_7.getName()) || StringUtils.equals(priorityGroup.getCode(),EnrollmentPriorityGroup.GROUP_8.getName())) {
                for(Iterator subIter=prioritySubGroups.iterator(); subIter.hasNext();) {
                    EnrollmentPrioritySubGroup prioritySubGroup = (EnrollmentPrioritySubGroup)subIter.next();
                    enPriGroups.add(new EnrollmentPriorityGroupAndSubGroup(priorityGroup,prioritySubGroup));
                }
            }
        }
        return enPriGroups;
    }
}
