// Package 
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

// ESR Classes
import gov.va.med.esr.common.model.lookup.VAFacilityType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.service.ServiceException;

/**
 * UI lookup DAO for Death Notification Site.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class DeathNotificationSiteDAO extends VAFacilityAbstractLookupDAO
{
    /**
     * Uses a custom DAO filter to get the list of VAFacility objects whose types is
     * a Medical Treating Faciliyt.
     *
     * @return The list of VAFacility objects.
     */
    public List findAll()
    {
        try
        {
            return getLookupService().getAllDeathNotificationSites();
        }
        catch (Exception ex)
        {
            throw new RuntimeException("Unable to get all death notification sites.", ex);
        }
    }
}
