package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;

// ESR Classes
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VAFacilityType;

/**
 * UI lookup DAO for claim folder locations.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class ClaimFolderLocationDAO extends VAFacilityAbstractLookupDAO
{
    private static Set claimFolderLocations = null;

    static
    {
        claimFolderLocations = new HashSet();
        claimFolderLocations.add(VAFacilityType.CODE_RO.getName());
        claimFolderLocations.add(VAFacilityType.CODE_ROANDIC.getName());
        claimFolderLocations.add(VAFacilityType.CODE_RO_OC.getName());
        claimFolderLocations.add(VAFacilityType.CODE_RPC.getName());
        claimFolderLocations.add(VAFacilityType.CODE_MROC.getName());
        claimFolderLocations.add(VAFacilityType.CODE_MROC_MRO.getName());
    }

    /**
     * Filters the standard list of VA Facilities based on claim folder location.
     *
     * @return The list of objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredLocations = new ArrayList();
        List allLocations = getLookupService().findAll(getBaseLookupClass());
        if (allLocations != null)
        {
            VAFacility facility = null;
            for (Iterator iter = allLocations.iterator(); iter.hasNext();)
            {
                facility = (VAFacility)iter.next();
                VAFacilityType facilityType = facility.getType();

                if (claimFolderLocations.contains(facilityType.getCode()))
                {
                    filteredLocations.add(facility);
                }
            }
        }

        // Sort the facilities
        sortFacilitiesByCode(filteredLocations);

        return filteredLocations;
    }
}
