// Package
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

// ESR Classes
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.service.UnknownLookupTypeException;

/**
 * UI lookup DAO for Address Phone Types.  Pre-certification is filtered out of the list of phone types.
 *
 * @author Venky Kullampalle
 * @version 3.0
 */
public class BadAddressReasonDAO extends UIAbstractLookupDAO
{
    private static Set invalidBadAddressReasons = null;

    static
    {
        invalidBadAddressReasons = new HashSet();
        invalidBadAddressReasons.add(BadAddressReason.CODE_ADDRESS_NOT_FOUND.getCode());
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return BadAddressReason.class;
    }

    /**
     * Filters the standard list of BadAddressResons to exclude invalid options for GUI.
     *
     * @return The list of BadAddressReason.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredBadAddressReasons = new ArrayList();
        List allBadAddressReasons = getLookupService().findAll(getBaseLookupClass());
        if (allBadAddressReasons != null)
        {
            BadAddressReason badAddressReason = null;
            for (Iterator iter = allBadAddressReasons.iterator(); iter.hasNext();)
            {
                badAddressReason = (BadAddressReason)iter.next();

                if (!invalidBadAddressReasons.contains(badAddressReason.getCode()))
                {
                    filteredBadAddressReasons.add(badAddressReason);
                }
            }
        }

        return filteredBadAddressReasons;
    }
}
