// Package
package gov.va.med.esr.ui.common.dao;

// Java Classes
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

// ESR Classes
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.service.UnknownLookupTypeException;

/**
 * UI lookup DAO for Address Phone Types.  Pre-certification is filtered out of the list of phone types.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class AddressPhoneTypeDAO extends UIAbstractLookupDAO
{
    private static Set invalidPhoneTypes = null;

    static
    {
        invalidPhoneTypes = new HashSet();
        invalidPhoneTypes.add(PhoneType.CODE_PRE_CERTIFICATION_PHONE.getCode());
        invalidPhoneTypes.add(PhoneType.CODE_CONFIDENTIAL.getCode());
    }

    /**
     * Returns the base lookup class that this UI DAO extends.
     *
     * @return the base lookup class.
     */
    public Class getBaseLookupClass()
    {
        return PhoneType.class;
    }

    /**
     * Filters the standard list of Phone Types to exclude pre-certification.
     *
     * @return The list of PhoneType objects.
     * @throws gov.va.med.esr.service.UnknownLookupTypeException
     * @throws ClassNotFoundException
     */
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException
    {
        List filteredPhoneTypes = new ArrayList();
        List allPhoneTypes = getLookupService().findAll(getBaseLookupClass());
        if (allPhoneTypes != null)
        {
            PhoneType phoneType = null;
            for (Iterator iter = allPhoneTypes.iterator(); iter.hasNext();)
            {
                phoneType = (PhoneType)iter.next();

                if (!invalidPhoneTypes.contains(phoneType.getCode()))
                {
                    filteredPhoneTypes.add(phoneType);
                }
            }
        }

        return filteredPhoneTypes;
    }
}
