/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.Lookup;

public class WorkflowSearchType extends UIAbstractLookup
{
    private static final long serialVersionUID = 4578846161156280591L;

    public static final Code CODE_ALL_ITEMS = new Code("1");
    public static final Code CODE_ASSIGNED_TO = new Code("2");
    public static final Code CODE_ASSIGNED_DATE = new Code("3");
    public static final Code CODE_CREATE_DATE = new Code("4");
    public static final Code CODE_FUNCTIONAL_GROUP = new Code("5");
    public static final Code CODE_ITEM_STATUS = new Code("6");
    public static final Code CODE_ITEM_TYPE = new Code("7");
    public static final Code CODE_SSN = new Code("8");
    public static final Code CODE_VPID = new Code("9");

    private static Map map;

    static
    {
        map = new HashMap();
        map.put("1", new WorkflowSearchType("1", "All Items"));
        map.put("2", new WorkflowSearchType("2", "Assigned To"));
        map.put("3", new WorkflowSearchType("3", "Assigned Date"));
        map.put("4", new WorkflowSearchType("4", "Create Date"));
        map.put("5", new WorkflowSearchType("5", "Functional Group"));
        map.put("6", new WorkflowSearchType("6", "Item Status"));
        map.put("7", new WorkflowSearchType("7", "Item Type"));
        map.put("8", new WorkflowSearchType("8", "SSN"));
        map.put("9", new WorkflowSearchType("9", "VPID"));
    }

    private WorkflowSearchType(String code, String description)
    {
        super(code, description);
    }

    public static List findAll()
    {
        return new ArrayList(map.values());
    }

    public static Lookup getByCode(String code)
    {
        return (Lookup)map.get(code);
    }

    public static class Code extends AbstractCode
    {

        private static final long serialVersionUID = -2301533895300043106L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }
}
