package gov.va.med.esr.ui.common.beans;

// Java classes
import java.io.Serializable;

// ESR Classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.fw.util.StringUtils;

/**
 * Bean to hold information that is displayed in the UI veteran header.
 * @author DNS   CHENB
 */
public class VeteranHeaderBean implements Serializable
{
    private static final long serialVersionUID = -2258479106568505062L;
    
    private String name;
    private String ssn;
    private String dob;
    private String dod;
    private String status;
    private String mergInfoID;
    private String personLockReason;
    private Boolean sensitiveRecord = Boolean.FALSE;
    private Boolean openCases = Boolean.FALSE;
    private boolean dataMergePending = false;
    private String memberId = null;

    /**
     * @return Returns the dob.
     */
    public String getDob()
    {
        return dob;
    }

    /**
     * @param dob The dob to set.
     */
    public void setDob(String dob)
    {
        this.dob = dob;
    }

    /**
     * @param dob The dob to set.
     */
    public void setDob(ImpreciseDate dob)
    {
        this.dob = DateUtils.format(dob, null);
    }

    /**
     * @return Returns the dod.
     */
    public String getDod()
    {
        return dod;
    }

    /**
     * @param dod The dod to set.
     */
    public void setDod(String dod)
    {
        this.dod = dod;
    }

    /**
     * @param dod The dod to set.
     */
    public void setDod(ImpreciseDate dod)
    {
        this.dod = DateUtils.format(dod, null);
    }

    /**
     * @return Returns the name.
     */
    public String getName()
    {
        return name;
    }

    /**
     * @param name The name to set.
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return Returns the ssn.
     */
    public String getSsn()
    {
        return ssn;
    }

    /**
     * @param ssn The ssn to set.
     */
    public void setSsn(String ssn)
    {
        this.ssn = JspUtils.displaySSN(ssn);
    }

    /**
     * @return Returns the status.
     */
    public String getStatus()
    {
        return status;
    }

    /**
     * @param status The status to set.
     */
    public void setStatus(String status)
    {
        this.status = status;
    }

    /**
     * @param MergInfoID The MergInfoID to get.
     */
	public String getMergInfoID() {
		return mergInfoID;
	}
	/**
     * @param mergInfoID The mergInfoID to set.
     */
	public void setMergInfoID(String mergInfoID) {
		this.mergInfoID = mergInfoID;
	}
	    	
    public void setSensitiveRecord(Boolean flag)
    {
        this.sensitiveRecord = flag;
    }

    public Boolean isSensitiveRecord()
    {
        return this.sensitiveRecord;
    }

    public Boolean getSensitiveRecord()
    {
        return this.sensitiveRecord;
    }

    public Boolean getOpenCases()
    {
        return openCases;
    }

    public void setOpenCases(Boolean openCases)
    {
        this.openCases = openCases;
    }

    /**
     * @return Returns the dataMergePending.
     */
    public boolean isDataMergePending()
    {
        return dataMergePending;
    }

    /**
     * @param dataMergePending The dataMergePending to set.
     */
    public void setDataMergePending(boolean dataMergePending)
    {
        this.dataMergePending = dataMergePending;
    }

    public String getPersonLockReason()
    {
        return personLockReason;
    }

    public void setPersonLockReason(String personLockReason)
    {
        this.personLockReason = personLockReason;
    }

    /**
     * Returns whether any data is present on line 1.
     * Line 1 fields: personLockReason, openCases, dataMergePending.
     * @return True if data is present or false if not.
     */
    public boolean getLine1DataPresent()
    {
        return ((StringUtils.isNotBlank(personLockReason)) || openCases.booleanValue() || dataMergePending);
    }

    /**
     * Returns whether any data is present on line 2.
     * Line 2 fields: name, ssn, dob, dod, status.
     * @return True if data is present or false if not.
     */
    public boolean getLine2DataPresent()
    {
        return ((StringUtils.isNotBlank(name)) ||
            (StringUtils.isNotBlank(ssn)) ||
            (StringUtils.isNotBlank(dob)) ||
            (StringUtils.isNotBlank(dod)) ||
            (StringUtils.isNotBlank(status)));
    }

    /**
     * Returns whether any data is present on line 1 or line 2.
     * @return True if data is present or false if not.
     */
    public boolean getAnyDataPresent()
    {
        return getLine1DataPresent() || getLine2DataPresent() || sensitiveRecord.booleanValue();
    }

	/**
	 * @return member id
	 */
	public String getMemberId() {
		return memberId;
	}

	/**
	 * @param memberId
	 */
	public void setMemberId(String memberId) {
		this.memberId = memberId;
	}
    
    
}
