/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.beans;

// ESR Classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * VISN lists 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class VISNSite extends AbstractNamedLookup
{
    private static final long serialVersionUID = -4135112533492343886L;
    private VAFacility facility = null;

    public VISNSite(VAFacility facility) {
        super();
        this.facility = facility;
    }
    
    public String getCode() {
        return (this.facility != null) ? this.facility.getCode() : "";
    }
    
    public String getName() {
        return (this.facility != null) ?  this.facility.getName() : "";
    }
    
    public String getDescription() {
        return (this.facility != null) ? this.facility.getDescription() : "";
    }
    
    public String getFacilityName() {
        String facilityName = "";
        if(this.facility != null) {
            facilityName = ".  " + this.facility.getFacilityName();
        }
        return facilityName;
    }
    
    public VAFacility getFacility(){
    	return facility;
    }
}
