/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.beans;

// ESR Classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * VISN lists 
 * 
 * @version 3.0
 */
public class VISNParentFacility extends AbstractNamedLookup
{
    /**
	 * 
	 */
	private static final long serialVersionUID = 7445953755866538434L;
	/**
	 * 
	 */
	private VAFacility facility = null;

    public VISNParentFacility(VAFacility facility) {
        super();
        this.facility = facility;
    }
    
    public String getCode() {
        return (this.facility != null) ? this.facility.getCode() : "";
    }
    
    public String getName() {
        return (this.facility != null) ?  this.facility.getName() : "";
    }
    
    public String getDescription() {
        return (this.facility != null) ? this.facility.getDescription() : "";
    }
    
    public String getFacilityName() {
        String facilityName = "";
        if(this.facility != null) {
            facilityName = ".  " + this.facility.getFacilityName();
        }
        return facilityName;
    }
    
    public VAFacility getFacility(){
    	return facility;
    }
}
