/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.beans;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * VAMC is used mainly for display purpose
 * @author Venky Kullampalle
 * @version 3.0
 */
public class VAMC extends AbstractNamedLookup
{
    
    
	private static final long serialVersionUID = 3641780610962750888L;
	protected VAFacility facility = null;
    public VAMC(VAFacility facility) {
        super();
        this.facility = facility;
    }
    
    public String getCode() {
        return (this.facility != null) ? this.facility.getCode() : "";
    }
    
    public String getName() {
        return (this.facility != null) ?  this.facility.getName() : "";
    }
    
    public String getDescription() {
        return (this.facility != null) ? this.facility.getDescription() : "";
    }
    
    public String getFacilityName() {
        String facilityName = "";
        if(this.facility != null) {
            facilityName = ".  " + this.facility.getFacilityName();
        }
        return facilityName;
    }
}

