/**
 * Created on 3:14:06 PM Jan 7, 2005
 * Project: UI
 * 
 * @author DNS   LEV
 */
package gov.va.med.esr.ui.common.beans;

// Framework classes
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;

/**
 * A value object containing data representing user information
 */
public class UserInfo extends AbstractEntity
{
    private static final long serialVersionUID = -2836427753376550150L;

    /**
     * A user's username
     */
    private String userID = null;

    /**
     * A user's password
     */
    private String password = null;

    /**
     * An empty value object containing user information
     */
    public UserInfo()
    {
        super();
    }

    /**
     * @return Returns the password.
     */
    public String getPassword()
    {
        return password;
    }

    /**
     * @param password The password to set.
     */
    public void setPassword(String password)
    {
        this.password = password;
    }

    /**
     * @return Returns the userName.
     */
    public String getUserID()
    {
        return userID;
    }

    /**
     * @param userName The userName to set.
     */
    public void setUserID(String userName)
    {
        this.userID = userName;
    }

    /**
     * Builds a string representation of a user information
     *
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        builder.append("userID", getUserID());
        builder.append("password", getPassword());
    }
}
