
package gov.va.med.esr.ui.common.action;

import gov.va.med.fw.util.StringUtils;

import java.io.Serializable;

/**
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class ZipCodeLookupBean implements Serializable
{
	private static final long serialVersionUID = 7979362675743230332L;
	private String zipCode;
    private String city;
    private String county;
    private String state;
    
    public ZipCodeLookupBean(){}
    
    public ZipCodeLookupBean(String zipCode,String city, String county, String state)
    {
        this.zipCode = zipCode;
        this.city = city;
        this.county = county;
        this.state = state;
    }
    
    public String getZipCode() 
    {
        return zipCode;
    }

    public void setZipCode(String zipCode) 
    {
        this.zipCode = zipCode;
    }
    
    public String getCity() 
    {
        return city;
    }
    
    public void setCity(String city) 
    {
        this.city = city;
    }

    public String getCounty() 
    {
        return county;
    }

    public void setCounty(String county) 
    {
        this.county = county;
    }

    public String getState() 
    {
        return state;
    }

    public void setState(String state) 
    {
        this.state = state;
    }

    /**
     * @return City, State (County County).
     */
    public String getFormattedZipLocation()
    {
        StringBuffer buffer = new StringBuffer();
        if(StringUtils.isNotEmpty(city))
        {
            buffer.append(city);
        }
        if(StringUtils.isNotEmpty(state))
        {
            if(buffer.length() > 0) buffer.append(", ");
            buffer.append(state);
        }
        if(StringUtils.isNotEmpty(county))
        {
            if (buffer.length() > 0)
            {
                buffer.append(" (").append(county).append(" COUNTY)");
            }
        }
        return buffer.toString();
    }

    public String getKeyString()
    {
        StringBuffer buffer = new StringBuffer();
        if(StringUtils.isNotEmpty(city))
        {
            buffer.append(city);
        }
        buffer.append(",");
        if(StringUtils.isNotEmpty(county))
        {
            buffer.append(county);
        }
        buffer.append(",");
        if(StringUtils.isNotEmpty(state))
        {
            buffer.append(state);
        }
        return buffer.toString();
    }
    
    public String toString() 
    {
        StringBuffer buffer = new StringBuffer();
        if(StringUtils.isNotEmpty(zipCode))
        {
            buffer.append(zipCode);
        }
        buffer.append(",");
        if(StringUtils.isNotEmpty(city))
        {
            buffer.append(city);
        }
        buffer.append(",");
        if(StringUtils.isNotEmpty(state))
        {
            buffer.append(state);
        }
        buffer.append(",");
        if(StringUtils.isNotEmpty(county))
        {
            buffer.append(county);
            buffer.append(" county");
        }
        return buffer.toString();
    }
}
