/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.action;

// Java classes
import gov.va.med.esr.common.model.lookup.ZipCode;
import gov.va.med.fw.util.StringUtils;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * Action handler for Zip code lookup.
 * 
 * @author Muddaiah Ranga
 * @version: 3.0
 */
public class ZipCodeLookupAction extends AbstractAction
{
    public static final String ZIP_CODE 				= "zipCode";
    public static final String ROOT_ELEMENT_START 		= "<message>";
    public static final String ROOT_ELEMENT_END   		= "</message>";
    
    public static final String ZIP_CODE_LOOKUP_START 	= "<zipCodeLookup>";
    public static final String ZIP_CODE_LOOKUP_END	 	= "</zipCodeLookup>";
    
    public static final String KEY_START 				= "<key>";
    public static final String KEY_END 					= "</key>";
    
    public static final String VALUE_START 				= "<value>";
    public static final String VALUE_END 				= "</value>";
    
    public ActionForward lookup(ActionMapping mapping, 
            				    ActionForm form,
            				    HttpServletRequest request, 
            				    HttpServletResponse response)
    throws Exception 
	{
        String zipCode = request.getParameter(ZIP_CODE);
        String xml = "";
        if(StringUtils.isNotEmpty(zipCode))
        {
            List list = getLookupCacheService().getZipCode(ZipCode.class,zipCode); 
            
//            long start = System.currentTimeMillis();
//            System.out.println(" startTime = " + start);
//            ZipCode ZipCode = (ZipCode)getLookupService().getByCode(ZipCode.class,zipCode);
//            if(ZipCode  != null)
//            {
//                ZipCode.getDescription();
//                ZipCode.getState().getName();
//            }
//            System.out.println("Time = " + (System.currentTimeMillis() - start));
            
            xml = buildLookupXml(list);
        }
        
        //Write the XML to response
        response.setContentType("text/xml");
        response.setHeader("Cache-Control","no-cache");
        PrintWriter out = response.getWriter();
        out.println(xml);
        out.flush();

        return null;
    }
    
    /**
     * Builds the xml from the list.
     * 
     * @param list the list of lookups
     * @return xml string.
     */
    private String buildLookupXml(List list)
    {
        StringBuffer xml = new StringBuffer();
        xml.append(ROOT_ELEMENT_START);
        if(list != null && !list.isEmpty())
        {
            for(Iterator iter = list.iterator(); iter.hasNext();)
            {
                ZipCodeLookupBean ZipCodeLookupBean = (ZipCodeLookupBean)iter.next();
                xml.append(ZIP_CODE_LOOKUP_START);
                xml.append(KEY_START);
                xml.append(ZipCodeLookupBean.getKeyString());
                xml.append(KEY_END);
                xml.append(VALUE_START);
                xml.append(ZipCodeLookupBean.getFormattedZipLocation());
                xml.append(VALUE_END);
                xml.append(ZIP_CODE_LOOKUP_END);	
            }
        }
        xml.append(ROOT_ELEMENT_END);
        return xml.toString();
    }

	/**
	 * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
	 */
	public void afterPropertiesSet() {
	}
}