/**
 * Created on 4:57:47 PM Jan 7, 2005
 * Project: UI
 *
 * @author DNS   LEV
 */
package gov.va.med.esr.ui.common.action;

// Framework classes
import java.util.Enumeration;

import gov.va.med.esr.ui.ApplicationConstants;
import gov.va.med.esr.ui.ApplicationConstants.MessageKeys;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.ui.struts.AbstractForm;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/**
 * A struts form to capture data from a log on screen
 */
public class UserInfoForm extends AbstractForm
{
    private static final long serialVersionUID = 8856365199071335937L;

    private boolean acceptAgreement = false;
    private boolean securityCodeRequired = false;

    public UserInfoForm()
    {
        super();
    }

    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        getUserCredentials().setUserID(null);
        getUserCredentials().setPassword(null);
        acceptAgreement = false;
        getUserCredentials().setSecurityCode(null);
    }

    //CCR13343 SSOi integration
    public void init(HttpServletRequest request, boolean ssoEnabled, String ssoUsername) {

        //if supported in env, login user from IAM header
        if (ssoEnabled) {
        	getUserCredentials().setUserID(request.getHeader(ApplicationConstants.SessionData.USER_HEADER));
        } else {
        	//if disabled then we bypass with anonymous user
        	getUserCredentials().setUserID(ssoUsername);
        }
        getUserCredentials().setPassword(ApplicationConstants.SessionData.SM_PASSWORD);

        if (logger.isDebugEnabled()) {
	        Enumeration<String> headerNames = request.getHeaderNames();
			while (headerNames.hasMoreElements()) {
				String headerName = headerNames.nextElement();
				logger.debug("Header Name: " + headerName);
				String headerValue = request.getHeader(headerName);
				logger.debug("Header Value: " + headerValue);
			}
        }

    }

    /**
     * @return Returns the password.
     */
    public String getPassword()
    {
        return getUserCredentials().getPassword();
    }

    /**
     * @param password The password to set.
     */
    public void setPassword(String password)
    {
        getUserCredentials().setPassword(password);
    }

    /**
     * @return Returns the userName.
     */
    public String getUserID()
    {
        return getUserCredentials().getUserID();
    }

    /**
     * @param userName The userName to set.
     */
    public void setUserID(String userName)
    {
        getUserCredentials().setUserID(userName);
    }

    public UserCredentials getUserCredentials()
    {
        return (UserCredentials)getVO();
    }

    public boolean isAcceptAgreement()
    {
        return acceptAgreement;
    }

    public void setAcceptAgreement(boolean acceptAgreement)
    {
        this.acceptAgreement = acceptAgreement;
    }

    public String getAgreementSignatureCode()
    {
        return getUserCredentials().getSecurityCode();
    }

    public void setAgreementSignatureCode(String agreementSignatureCode)
    {
        getUserCredentials().setSecurityCode(agreementSignatureCode);
    }

    public boolean isSecurityCodeRequired()
    {
        return securityCodeRequired;
    }

    public void setSecurityCodeRequired(boolean securityCodeRequired)
    {
        this.securityCodeRequired = securityCodeRequired;
    }

    /*
     * @see org.apache.struts.validator.ValidatorForm#validate(org.apache.struts.action.ActionMapping, javax.servlet.http.HttpServletRequest)
     */
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = super.validate(mapping, request);
        if(errors != null && !errors.isEmpty()) {
            reset(mapping,request);
            errors.add("",new ActionMessage(AbstractLogonAction.MESSAGE_LOGON_NOT_ATTEMPTED));
        }
        return errors;
    }

    /**
     * @see gov.va.med.fw.ui.struts.AbstractForm#createValueObject()
     */
    protected AbstractEntity createValueObject()
    {
        return new UserCredentials();
    }
}
