/********************************************************************
 * Copyright  2004-2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.action;

// Java Classes
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// ESR Classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * A command class to remove application data from a session and log a user out
 * of a his / her current session then a session is invalidated
 *
 * @author DNS   LEV
 * @version: 1.0
 */
public class SignoutAction extends AbstractLogonAction
{
    public SignoutAction() {
        super();
    }

    public void afterPropertiesSet() throws Exception {
        if (loginManager == null) {
            throw new IllegalArgumentException(
                    "Missing required property - LoginManager: Must be specified.");
        }
    }

    /**
     * Signout and return to logon screen.
     *
     * @param mapping
     *            An action mapping
     * @param form
     *            A form bean
     * @param request
     *            A http request from an search.jsp page
     * @param response
     *            A http response to stream data to a next page
     * @return An action forward class encapsulating information about a next
     *         page
     * @throws java.lang.Exception
     *             Thrown if failed to process
     */
    public ActionForward signout(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception
    {
        // If the password is changed in this session, display a warning message.
        if(getSandboxEntry(request,PASSWORD_CHANGED_KEY) != null)
        {
            addInformationMessage(request,MESSAGE_PASSWORD_CHANGED);
        }

        // Process the signout
        processSignout(request,null);

        //CCR13343 SSOi integration
        //return mapping.findForward("success");
        ActionForward fwd = new ActionForward(getUserAdminService().getSsoLogoffUrl(),true);

        return fwd;
    }
}