/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.action;

import java.util.List;

import javax.servlet.ServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.ui.struts.AbstractForm;

/**
 * @author DNS   KATIKM Generic form to hold history information for selected entity
 */
public class HistoryForm extends AbstractForm
{
    private static final long serialVersionUID = 7914125502952422762L;
    
    private String changeEventKey = null;
    private String historyConfigName = null;
    private List historicalInfo = null;
    private String actionName = null;
    private String returnLinkMessageKey = null;
    private String title = null;
    private boolean currentDeleted = false;

    /**
     * default Constructor
     */
    public HistoryForm()
    {
        super();
    }

    public String getChangeEventKey()
    {
        return changeEventKey;
    }

    public List getHistoricalInfo()
    {
        return historicalInfo;
    }

    public String getHistoryConfigName()
    {
        return historyConfigName;
    }

    public String getActionName()
    {
        return actionName;
    }

    public String getTitle()
    {
        return title;
    }

    public void setChangeEventKey(String changeEventKey)
    {
        this.changeEventKey = changeEventKey;
    }

    public void setHistoricalInfo(List historicalInfo)
    {
        this.historicalInfo = historicalInfo;
    }

    public void setHistoryConfigName(String historyConfigName)
    {
        this.historyConfigName = historyConfigName;
    }

    public void setActionName(String actionName)
    {
        this.actionName = actionName;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public void reset(ActionMapping arg0, ServletRequest arg1)
    {
        super.reset(arg0, arg1);
        init();
    }

    public String getReturnLinkMessageKey()
    {
        return returnLinkMessageKey;
    }

    public void setReturnLinkMessageKey(String returnLinkMessageKey)
    {
        this.returnLinkMessageKey = returnLinkMessageKey;
    }

    public boolean isCurrentDeleted() {
        return currentDeleted;
    }

    public void setCurrentDeleted(boolean currentDeleted) {
        this.currentDeleted = currentDeleted;
    }

    private void init()
    {
        changeEventKey = null;
        historyConfigName = null;
        historicalInfo = null;
        actionName = null;
        returnLinkMessageKey = null;
        title = "History";
        currentDeleted = false;
    }
}
