/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author DNS   KATIKM Data bean to hold the History configuration information service name, method calls field
 *         mappings
 */
public class HistoryConfiguration implements Serializable
{
    private static final long serialVersionUID = -3320098049501895518L;

    String serviceName = null;
    String changeEventsMethodName = "";
    String historyMethodName = "";
    String title = "History";
    String actionName = "";
    String returnActionForward = "";
    String returnLinkMessageKey = "";
    List parameterValues = null;
    List parameterNames = null;
    Map displayPropertyMap = null;
    Map displayObjectMap = null;
    Map fieldMap = new HashMap();
    String entityClassName = null;
    String returnPath = null;

    public String getChangeEventsMethodName()
    {
        return changeEventsMethodName;
    }

    public String getHistoryMethodName()
    {
        return historyMethodName;
    }

    public String getServiceName()
    {
        return serviceName;
    }

    public String getTitle()
    {
        return title;
    }

    public Map getDisplayPropertyMap()
    {
        if (displayPropertyMap == null)
        {
            displayPropertyMap = new LinkedHashMap();
        }
        return displayPropertyMap;
    }

    public Map getDisplayObjectMap()
    {
        if (displayObjectMap == null)
        {
            displayObjectMap = new LinkedHashMap();
        }
        return displayObjectMap;
    }

    public void setChangeEventsMethodName(String changeEventsMethodName)
    {
        this.changeEventsMethodName = changeEventsMethodName;
    }

    public void setHistoryMethodName(String historyMethodName)
    {
        this.historyMethodName = historyMethodName;
    }

    public void setServiceName(String serviceName)
    {
        this.serviceName = serviceName;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public void setDisplayPropertyMap(Map displayPropertyMap)
    {
        this.displayPropertyMap = displayPropertyMap;
    }

    public void setDisplayObjectMap(Map displayObjectMap)
    {
        this.displayObjectMap = displayObjectMap;
    }

    public String getActionName()
    {
        return actionName;
    }

    public void setActionName(String actionName)
    {
        this.actionName = actionName;
    }

    public String getReturnActionForward()
    {
        return returnActionForward;
    }

    public void setReturnActionForward(String returnActionForward)
    {
        this.returnActionForward = returnActionForward;
    }

    public String getReturnLinkMessageKey()
    {
        return returnLinkMessageKey;
    }

    public void setReturnLinkMessageKey(String returnLinkMessageKey)
    {
        this.returnLinkMessageKey = returnLinkMessageKey;
    }
    
	public String getReturnPath() {
        return returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public List getParameterNames() {
		if (parameterNames == null)
			parameterNames = new ArrayList ();
		return parameterNames;
	}
	public List getParameterValues() {
		if (parameterValues == null)
			parameterValues = new ArrayList ();		
		return parameterValues;
	}
	public void setParameterNames(List parameterNames) {
		this.parameterNames = parameterNames;
	}
	public void setParameterValues(List parameterValues) {
		this.parameterValues = parameterValues;
	}

    public String getEntityClassName() {
        return entityClassName;
    }

    public void setEntityClassName(String entityClassName) {
        this.entityClassName = entityClassName;
    }    
}
