// Package 
package gov.va.med.esr.ui.common.action;

// Java Classes
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.List;
import java.util.Iterator;

// Library Classes
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForm;

/**
 * Action handler for Async. Message Retrieval.
 *
 * @author Andrew Pach
 * @version: 3.0
 */
public class GetAsyncMessagesAction extends AbstractAction
{
    // XML Tags
    public static final String ROOT_ELEMENT_START = "<message>";
    public static final String ROOT_ELEMENT_END = "</message>";
    public static final String USER_MESSAGES_START = "<userMessages>";
    public static final String USER_MESSAGES_END = "</userMessages>";
    public static final String VALUE_START = "<value>";
    public static final String VALUE_END = "</value>";

    /**
     * Gets any async messages.
     * @param mapping The ActionMapping
     * @param form The ActionForm
     * @param request The HttpServletRequest
     * @param response The HttpServletResponse
     * @return The ActionForward
     * @throws Exception if any problems were encountered
     */
    public ActionForward getAsyncMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception
    {
        // Get the messages and build the response XML
        String xml = buildResponseXml(getAsyncMessagesFromSession(request));

        // Write the XML to the response
        response.setContentType("text/xml");
        response.setHeader("Cache-Control","no-cache");
        PrintWriter out = response.getWriter();
        out.println(xml);
        out.flush();

        // Return null so Struts doesn't do anything
        return null;
    }

    /**
     * Gets any new async messages and clears them out from the session.
     * @param request The HttpServletRequest
     * @return The list of new messages
     */
    protected List getAsyncMessagesFromSession(HttpServletRequest request)
    {
        // Get any new messages
        List asyncMessages = getAsyncMessages(request.getSession());
        if ((asyncMessages != null) && (asyncMessages.size() > 0))
        {
            // Clear out the messages
            setAsyncMessages(request.getSession(), null);
        }
        return asyncMessages;
    }

    /**
     * Builds the response XML message
     * @param messages the list of messages
     * @return The response XML message
     */
    protected String buildResponseXml(List messages)
    {
        StringBuffer xml = new StringBuffer();
        xml.append(GetAsyncMessagesAction.ROOT_ELEMENT_START);
        if ((messages != null) && (messages.size() > 0))
        {
            xml.append(GetAsyncMessagesAction.USER_MESSAGES_START);
            for (Iterator iterator = messages.iterator(); iterator.hasNext();)
            {
                // Get a message
                String message = (String)iterator.next();

                // Enclose each message in start and end tags so the caller can
                // easily determine that a message is present
                xml.append(GetAsyncMessagesAction.VALUE_START);
                xml.append(message);
                xml.append(GetAsyncMessagesAction.VALUE_END);
            }
            xml.append(GetAsyncMessagesAction.USER_MESSAGES_END);
        }
        xml.append(GetAsyncMessagesAction.ROOT_ELEMENT_END);
        return xml.toString();
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet()
    {
    }
}
