// Package 
package gov.va.med.esr.ui.common.action;

// Java Classes
import java.io.PrintWriter;

// Library Classes
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForm;
import org.apache.commons.lang.Validate;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// ESR Classes
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.fw.util.StringUtils;

/**
 * Action handler for Phone Number formatting.
 *
 * @author Andrew Pach
 * @version: 3.0
 */
public class FormatPhoneNumberAction extends AbstractAction
{
    // Request parameters
    public static final String PHONE_NUMBER_PARAM = "phoneNumber";
    public static final String FIELD_NAME_PARAM = "fieldName";

    // XML Tags
    public static final String ROOT_ELEMENT_START = "<message>";
    public static final String ROOT_ELEMENT_END = "</message>";
    public static final String PHONE_NUMBER_START = "<phoneNumber>";
    public static final String PHONE_NUMBER_END = "</phoneNumber>";
    public static final String VALUE_START = "<value>";
    public static final String VALUE_END = "</value>";
    public static final String FIELD_NAME_START = "<fieldName>";
    public static final String FIELD_NAME_END = "</fieldName>";

    /**
     * Formats a phone number
     * @param mapping The ActionMapping
     * @param form The ActionForm
     * @param request The HttpServletRequest
     * @param response The HttpServletResponse
     * @return The ActionForward
     * @throws Exception if any problems were encountered
     */
    public ActionForward format(ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception
    {
        // Get the unformatted phone number from the request
        String phoneNumber = request.getParameter(FormatPhoneNumberAction.PHONE_NUMBER_PARAM);

        // Get the field name from the request
        String fieldName = request.getParameter(FormatPhoneNumberAction.FIELD_NAME_PARAM);

        // Ensure a field name was passed
        Validate.notNull(fieldName, "No field name was found on the format phone number request.");

        // Format the phone number and build the response XML
        String xml = buildResponseXml(Phone.getFormattedPhone(phoneNumber), fieldName);

        // Write the XML to the response
        response.setContentType("text/xml");
        response.setHeader("Cache-Control","no-cache");
        PrintWriter out = response.getWriter();
        out.println(xml);
        out.flush();

        // Return null so Struts doesn't do anything
        return null;
    }

    /**
     * Builds the response XML message
     * @param phoneNumber The formatted phone number
     * @param fieldName The field name to return back to the caller
     * @return The response XML message
     */
    private String buildResponseXml(String phoneNumber, String fieldName)
    {
        StringBuffer xml = new StringBuffer();
        xml.append(FormatPhoneNumberAction.ROOT_ELEMENT_START);
        if (StringUtils.isNotEmpty(phoneNumber))
        {
            // Enclose the formatted phone number in start and end tags so the caller can
            // easily determine that a formatted phone number is present
            xml.append(FormatPhoneNumberAction.PHONE_NUMBER_START);
            xml.append(FormatPhoneNumberAction.VALUE_START);
            xml.append(phoneNumber);
            xml.append(FormatPhoneNumberAction.VALUE_END);
            xml.append(FormatPhoneNumberAction.FIELD_NAME_START);
            xml.append(fieldName);
            xml.append(FormatPhoneNumberAction.FIELD_NAME_END);
            xml.append(FormatPhoneNumberAction.PHONE_NUMBER_END);
        }
        xml.append(FormatPhoneNumberAction.ROOT_ELEMENT_END);
        return xml.toString();
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet()
    {
    }
}
