/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.action;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.security.ChangePasswordInfo;

/**
 * ActionForm for change password.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class ChangePasswordInfoForm extends UserInfoForm
{
    private static final long serialVersionUID = 2764823014334382776L;
    private String repeatedNewPassword;

    public ChangePasswordInfoForm()
    {
        super();
    }
	
	public String getNewPassword() 
	{
		return getChangePasswordInfo().getNewPassword();
	}

	public void setNewPassword(String newPassword) 
	{
		getChangePasswordInfo().setNewPassword(newPassword);
	}
	
	public String getRepeatedNewPassword() 
	{
		return repeatedNewPassword;
	}

	public void setRepeatedNewPassword(String repeatedNewPassword) 
	{
		this.repeatedNewPassword = repeatedNewPassword;
	}
	
	public ChangePasswordInfo getChangePasswordInfo() 
	{
	      return (ChangePasswordInfo)getVO();
	}
	   
    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        setNewPassword(null);
        setRepeatedNewPassword(null);
    }
    
	protected AbstractEntity createValueObject() 
	{
		return new ChangePasswordInfo();
	}
}
