/*********************************************************************
 * Copyright  2004-2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.beans;

// Java classes
import java.io.Serializable;

// Framework Classes
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.util.ComparableBoolean;
import gov.va.med.person.idmgmt.ISaveableMessage;

// Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;


// ESR Classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.SelfIdentifiedGenderIdentity;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.PersonLockedReason;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.util.JspUtils;

/**
 * @author Andrew Pach
 * @version 3.0
 *          <p/>
 *          Value Object to hold search results.
 */
public class VeteranSearchBean extends AbstractEntity implements Serializable
{
    private static final long serialVersionUID = -5531835051615328574L;

    private String personID = null;
    private String ssn = null;
    private String firstName = null;
    private String middleName = null;
    private String lastName = null;
    private ImpreciseDate dateOfBirth = null;
    private ComparableBoolean sensitiveRecord = null;
    private PersonLockedReason personLockedReason = null;

    //  CCR 10471 ADD A PERSON
    private boolean addAPerson;
    private String preferredFacility = null; // Preferred Facility is a Required field but not an identity trait
    private String multipleBirth = null;
    private String mothersMaidenName = null;
    //private String placeOfBirthCity = null;
    //private String placeOfBirthState = null;
    private String address = null;
    private String city = null;
    private String state = null;
    private String zipCode = null;
    private String postalCode = null;
    private String country = null;
    private String homePhoneNumber = null;
    private String registrationStatus = null;  // "NEW REGISTRATION", "IN PROCESS", "COMPLETE"
    private String vpid = null;
    private Gender gender = null;
    private SelfIdentifiedGenderIdentity sigi = null;
    private int idmMatchType;
    private String idmMatchTypeValue = null; // Potential (idmMatchType=1) , Yes (idmMatchType=2)
	public static final String POTENTIAL_MATCH = "Potential";
	public static final String EXACT_MATCH = "Yes";

    /**
     * Default constructor.
     */
    public VeteranSearchBean()
    {
        super();
    }

    public String getPersonID()
    {
        return personID;
    }

    public void setPersonID(String value)
    {
        personID = value;
    }

    public String getSsn()
    {
        return ssn;
    }

    public void setSsn(String value)
    {
        ssn = JspUtils.isValidSSN(value) ? JspUtils.displaySSN(value) : value;
    }

    public String getLastName()
    {
        return lastName;
    }

    public void setLastName(String value)
    {
        lastName = value;
    }

    public String getFirstName()
    {
        return firstName;
    }

    public void setFirstName(String value)
    {
        firstName = value;
    }

    public String getMiddleName()
    {
        return middleName;
    }

    public void setMiddleName(String value)
    {
        middleName = value;
    }

    public String getFormattedDateOfBirth()
    {
        return DateUtils.format(dateOfBirth, null);
    }

    public ImpreciseDate getDateOfBirth()
    {
        return dateOfBirth;
    }

    public void setDateOfBirth(ImpreciseDate dateOfBirth)
    {
        this.dateOfBirth = dateOfBirth;
    }

    public ComparableBoolean getSensitiveRecord()
    {
        return sensitiveRecord;
    }

    public void setSensitiveRecord(ComparableBoolean sensitiveRecord)
    {
        this.sensitiveRecord = sensitiveRecord;
    }

    public void setSensitiveRecord(Boolean sensitiveRecord)
    {
        this.sensitiveRecord = new ComparableBoolean(sensitiveRecord);
    }

    public PersonLockedReason getPersonLockedReason()
    {
        return personLockedReason;
    }

    public void setPersonLockedReason(PersonLockedReason personLockedReason)
    {
        this.personLockedReason = personLockedReason;
    }

    public boolean isPersonLocked()
    {
        return getPersonLockedReason() != null;
    }

    /**
     * Format toString method
     *
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        builder.append("personID", getPersonID());
        builder.append("ssn", getSsn());
        builder.append("firstName", getFirstName());
        builder.append("lastName", getLastName());
        builder.append("middleName", getMiddleName());
        builder.append("dateOfBirth", getDateOfBirth());

        if (!isAddAPerson())
        	builder.append("sensitiveRecord", getSensitiveRecord());

        builder.append("personLockedReason", getPersonLockedReason());
        //CCR 10471 ADD A PERSON
        builder.append("addAPerson", isAddAPerson());
        builder.append("preferredFacility", getPreferredFacility());
        builder.append("multipleBirth", getMultipleBirth());
        //builder.append("placeOfBirthCity", getPlaceOfBirthCity());
        //builder.append("placeOfBirthState", getPlaceOfBirthState());
        builder.append("address",getAddress());
        builder.append("city",getCity());
        builder.append("state",getState());
        builder.append("zipCode",getZipCode());
        builder.append("postalCode",getPostalCode());
        builder.append("country",getCountry());
        builder.append("homePhoneNumber",getHomePhoneNumber());
        builder.append("idmMatchType",getIdmMatchType());
        builder.append("idmMatchTypeValue",getIdmMatchTypeValue());
        builder.append("vpid",getVpid());
    }

	public String getPreferredFacility() {
		return preferredFacility;
	}

	public void setPreferredFacility(String preferredFacility) {
		this.preferredFacility = preferredFacility;
	}

	public boolean isAddAPerson() {
		return addAPerson;
	}

	public void setAddAPerson(boolean addAPerson) {
		this.addAPerson = addAPerson;
	}

	public String getRegistrationStatus() {
		return registrationStatus;
	}

	public void setRegistrationStatus(String registrationStatus) {
		this.registrationStatus = registrationStatus;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getHomePhoneNumber() {
		return homePhoneNumber;
	}

	public void setHomePhoneNumber(String homePhoneNumber) {
		this.homePhoneNumber = homePhoneNumber;
	}

	public String getPostalCode() {
		return postalCode;
	}

	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	public int getIdmMatchType() {
		return idmMatchType;
	}

	public void setIdmMatchType(int idmMatchType) {
		this.idmMatchType = idmMatchType;
	}

	public String getMultipleBirth() {
		return multipleBirth;
	}

	public void setMultipleBirth(String multipleBirth) {
		this.multipleBirth = multipleBirth;
	}

	public String getIdmMatchTypeValue() {
		String idmMatchTypeValueString;
		if (getIdmMatchType() == 1)
			idmMatchTypeValueString = this.POTENTIAL_MATCH;
		else if (getIdmMatchType() == 2)
			idmMatchTypeValueString = this.EXACT_MATCH;
		else
			idmMatchTypeValueString = "";
		return idmMatchTypeValueString;
	}

	public void setIdmMatchTypeValue(String idmMatchTypeValue) {
		this.idmMatchTypeValue = idmMatchTypeValue;
	}

	public Gender getGender() {
		return gender;
	}

	public void setGender(Gender gender) {
		this.gender = gender;
	}

	public SelfIdentifiedGenderIdentity getSigi() {
		return sigi;
	}

	public void setSigi(SelfIdentifiedGenderIdentity sigi) {
		this.sigi = sigi;
	}

	public String getVpid() {
		return vpid;
	}

	public void setVpid(String vpid) {
		this.vpid = vpid;
	}


}
