/*********************************************************************
 * Copyright  2004-2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.beans;

// Java classes
import gov.va.med.fw.util.StringUtils;

import java.io.Serializable;
import java.util.Date;

// Framework Classes

// Library Classes

// ESR Classes

/**
 * @author Andrew Pach
 * @version 3.0
 *          <p/>
 *          Value Object to hold user session information.
 */
public class UserSessionBean implements Serializable, Comparable
{
    private static final long serialVersionUID = 8833745341340401676L;
    
    /** The number of seconds to consider a session idle. */
    public static final int IDLE_SECONDS = 600;

    private Date creationTime;
    private Date lastAccessedTime;
    private String id;
    private int maxInactiveInterval;
    private String username;
    private String remoteIpAddress;
    private boolean currentSession;

    /**
     * Default constructor.
     */
    public UserSessionBean()
    {
        super();
    }

    public Date getCreationTime()
    {
        return creationTime;
    }

    public void setCreationTime(Date creationTime)
    {
        this.creationTime = creationTime;
    }

    public Date getLastAccessedTime()
    {
        return lastAccessedTime;
    }

    public void setLastAccessedTime(Date lastAccessedTime)
    {
        this.lastAccessedTime = lastAccessedTime;
    }

    public String getId()
    {
        return id;
    }

    public void setId(String id)
    {
        this.id = id;
    }

    public int getMaxInactiveInterval()
    {
        return maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval)
    {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public String getUsername()
    {
        return username;
    }

    public void setUsername(String username)
    {
        this.username = username;
    }

    public String getRemoteIpAddress()
    {
        return remoteIpAddress;
    }

    public void setRemoteIpAddress(String remoteIpAddress)
    {
        this.remoteIpAddress = remoteIpAddress;
    }

    public boolean isCurrentSession()
    {
        return currentSession;
    }

    public void setCurrentSession(boolean currentSession)
    {
        this.currentSession = currentSession;
    }

    /**
     * Returns the number of seconds until the session will expire due to no activity.
     * @return The seconds until expire.
     */
    public String getSecondsUntilExpire()
    {
        if (maxInactiveInterval <= 0)
        {
            return "";
        }
        else
        {
            int remainingTime = maxInactiveInterval - getIdleSeconds();
            return String.valueOf(remainingTime < 0 ? 0 : remainingTime);
        }
    }

    /**
     * Gets the time that the session has been idle in seconds or 0 if it couldn't be determined.
     *
     * @return The number of seconds the session has been idle.
     */
    public int getIdleSeconds()
    {
        if (lastAccessedTime == null)
        {
            return 0;
        }
        else
        {
            return (int)((new Date().getTime() - lastAccessedTime.getTime()) / 1000);
        }
    }

    /**
     * Returns whether a session is idle.  A session is considered idle if it hasn't been accessed
     * in > IDLE_SECONDS.
     *
     * @return True if idle or false if not.
     */
    public boolean isIdle()
    {
        return getIdleSeconds() > IDLE_SECONDS;
    }

    public int compareTo(Object object)
    {
        if ((object != null) || (object instanceof UserSessionBean))
        {
            UserSessionBean objBean = (UserSessionBean)object;
            return StringUtils.compareTo(getUsername(), objBean.getUsername());
        }
        return 0;
    }

    public String toString()
    {
        return "Username: " + username;
    }
}