/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.ui.struts.AbstractForm;

public class UserForm extends AbstractForm {

    private static final long serialVersionUID = -3808516486572003766L;

    private String userId;
    private String name;
    private String givenName;
    private String middleName;
    private String familyName;
    private String jobTitle;
    private String facility;
    private String facilityName;
    private String password;
    private String confirmationPassword;
    private String passwordSuspendDate;
    private String passwordCreationDate;
    private String agreementSignatureCode;
    private String passwordLastChangeDate;
    private String passwordExpireDate;
    private int loginAttempFailureCount;
    private String loginAttemptFailureDate;
    private String lastLoginDate;
    private String accountLockDate;
    private String functionalGroup;

    public UserForm() {
        super();
        initialize();
    }

    protected void initialize() {
        userId = null;
        name = null;
        givenName = null;
        middleName = null;
        familyName = null;
        jobTitle = null;
        facility = null;
        facilityName = null;
        password = null;
        confirmationPassword = null;
        passwordSuspendDate = null;
        passwordCreationDate = null;
        agreementSignatureCode = null;
        passwordLastChangeDate = null;
        loginAttempFailureCount = 0;
        loginAttemptFailureDate = null;
        lastLoginDate = null;
        functionalGroup = null;
        accountLockDate = null;
    }

    public String getAgreementSignatureCode() {
        return agreementSignatureCode;
    }

    public void setAgreementSignatureCode(String agreementSignatureCode) {
        this.agreementSignatureCode = agreementSignatureCode;
    }

    //CCR13343 SSOi integration
    public String getAccountLockDate() {
    	return accountLockDate;
    }

    public void setAccountLockDate(String accountLockDate) {
    	this.accountLockDate = accountLockDate;
    }

    public String getConfirmationPassword() {
        return confirmationPassword;
    }

    public void setConfirmationPassword(String confirmationPassword) {
        this.confirmationPassword = confirmationPassword;
    }

    public String getFacility() {
        return facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public String getFacilityName() {
        return facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    public String getFamilyName() {
        return familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public String getGivenName() {
        return givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getJobTitle() {
        return jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public String getLastLoginDate() {
        return lastLoginDate;
    }

    public void setLastLoginDate(String lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public int getLoginAttempFailureCount() {
        return loginAttempFailureCount;
    }

    public void setLoginAttempFailureCount(int loginAttempFailureCount) {
        this.loginAttempFailureCount = loginAttempFailureCount;
    }

    public String getLoginAttemptFailureDate() {
        return loginAttemptFailureDate;
    }

    public void setLoginAttemptFailureDate(String loginAttemptFailureDate) {
        this.loginAttemptFailureDate = loginAttemptFailureDate;
    }

    public String getMiddleName() {
        return middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordCreationDate() {
        return passwordCreationDate;
    }

    public void setPasswordCreationDate(String passwordCreationDate) {
        this.passwordCreationDate = passwordCreationDate;
    }

    public String getPasswordLastChangeDate() {
        return passwordLastChangeDate;
    }

    public void setPasswordLastChangeDate(String passwordLastChangeDate) {
        this.passwordLastChangeDate = passwordLastChangeDate;
    }

    public String getPasswordSuspendDate() {
        return passwordSuspendDate;
    }

    public void setPasswordSuspendDate(String passwordSuspendDate) {
        this.passwordSuspendDate = passwordSuspendDate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFunctionalGroup() {
        return functionalGroup;
    }

    public void setFunctionalGroup(String functionalGroup) {
        this.functionalGroup = functionalGroup;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPasswordExpireDate() {
        return passwordExpireDate;
    }

    public void setPasswordExpireDate(String passwordExpireDate) {
        this.passwordExpireDate = passwordExpireDate;
    }

    public String getFullName() {
        StringBuffer name = new StringBuffer ();
        name.append(givenName == null ? "" : givenName);name.append(" ");
        name.append(familyName == null ? "" : familyName);name.append(" ");
        name.append(middleName == null ? "" : middleName);
        String fullName = name.toString();
        return fullName.trim();
    }

    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        super.reset(arg0, arg1);
        initialize();
    }
}
