/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;

import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.util.NameHelper;

public class UserAdminConversionService extends UIConversionServiceImpl {

    public UserAdminConversionService() {
        super();
    }

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof ESRUserPrincipalImpl && target instanceof UserForm) {
            convertUserToForm((ESRUserPrincipalImpl)source,(UserForm)target);
        }
        else if (target instanceof ESRUserPrincipalImpl && source instanceof UserForm) {
            convertFormToUser((UserForm)source,(ESRUserPrincipalImpl)target);
        }
        else
        {
            throw new ConversionServiceException("Can not conver from " +
                    source.getClass().getName() + " to " + target.getClass().getName());
        }
    }

    private void convertUserToForm(ESRUserPrincipalImpl user, UserForm form) {
        //Set the key value if it is an existing user
        form.setUserId(user.getEntityKey() == null ? null :
            user.getEntityKey().getKeyValueAsString());
        form.setName(user.getName()); //userid
        form.setGivenName(user.getGivenName());
        form.setFamilyName(user.getFamilyName());
        form.setMiddleName(user.getMiddleName());
        form.setJobTitle(user.getJobTitle());
        form.setFacility(getLookupCode(user.getFacility()));
        form.setPasswordSuspendDate(DateUtils.format(user.getPasswordSuspendDate(),null));
        form.setPasswordExpireDate(DateUtils.format(user.getPasswordExpireDate(),null));
        form.setPasswordCreationDate(DateUtils.format(user.getPasswordCreateDate(),null));
        form.setAgreementSignatureCode(user.getAgreementSignatureCode());
        form.setPasswordLastChangeDate(DateUtils.formatWithTime(user.getPasswordChangeDate(),null));
        form.setLoginAttempFailureCount(user.getFailAttemptCount());
        form.setLastLoginDate(DateUtils.formatWithTime(user.getSuccessfulLoginDate(),null));//TODO map
        form.setLoginAttemptFailureDate(DateUtils.formatWithTime(user.getFailedLoginDate(),null));//TODO
        form.setAccountLockDate(DateUtils.format(user.getLockDate(),null));
        form.setFunctionalGroup(getLookupCode(user.getFunctionalGroup()));
    }

    private void convertFormToUser(UserForm form, ESRUserPrincipalImpl user)
    throws ConversionServiceException{

        user.setGivenName(StringUtils.isBlank(form.getGivenName()) ? null : form.getGivenName());
        user.setFamilyName(StringUtils.isBlank(form.getFamilyName()) ? null : form.getFamilyName());
        user.setMiddleName(StringUtils.isBlank(form.getMiddleName()) ? null : form.getMiddleName());
        String fullName = NameHelper.formatNameLastNameFirst(user);
        user.setFullName(StringUtils.isBlank(fullName) ? null : fullName);
        user.setJobTitle(StringUtils.isBlank(form.getJobTitle()) ? null : form.getJobTitle());
        try {
            if (StringUtils.isNotEmpty(form.getFacility())) {
                user.setFacility((VAFacility)getLookupCacheService().
                        getByCodeFromCache(VAFacility.class,form.getFacility()));
            }
            else {
                user.setFacility(null);
            }

            if (StringUtils.isNotEmpty(form.getFunctionalGroup())) {
                user.setFunctionalGroup((FunctionalGroup)getLookupCacheService().
                        getByCodeFromCache(FunctionalGroup.class,form.getFunctionalGroup()));
            }
            else {
                user.setFunctionalGroup(null);
            }
        }catch (Exception ex) {
            throw new ConversionServiceException(ex.getMessage(),ex);
        }

        user.setPasswordSuspendDate(DateUtils.getDate(form.getPasswordSuspendDate()));
        user.setPasswordExpireDate(DateUtils.getDate(form.getPasswordExpireDate()));
        //CCR13343 SSOi integration
        user.setLockDate(DateUtils.getDate(form.getAccountLockDate()));
        user.setFailAttemptCount(form.getLoginAttempFailureCount());
        //reset the lock date if the fail attempt count is reset
        /*if (form.getLoginAttempFailureCount() == 0) {
            user.setLockDate(null);
        }*/
    }
}